#ifndef _WIN32_DCOM
#define _WIN32_DCOM
#endif

#include <windows.h>
#include <objbase.h>
#include <atlbase.h>
#include <iostream>
#include <wbemidl.h>
#include <comutil.h>

#include "PingSink.h"
#include "PingSinkUnsecure.h"

int main( int argc, char** argv )
{
	HRESULT hr = CoInitializeEx( NULL, COINIT_MULTITHREADED );
	if ( FAILED( hr ) )
	{
		std::cerr << "COM initialization failed" << std::endl;
		return -1;
	}

	// setup process-wide security context
	hr = CoInitializeSecurity( NULL, // we're not a server
							   -1, // we're not a server
							   NULL, // dito
							   NULL, // reserved
							   RPC_C_AUTHN_LEVEL_DEFAULT, // let DCOM decide
							   RPC_C_IMP_LEVEL_IMPERSONATE,
							   NULL,
							   EOAC_NONE,
							   NULL );
	if ( FAILED( hr ) )
	{
		std::cerr << "Security initialization failed" << std::endl;
		return -1;
	}

	int result = 0;
	// we're going to use CComPtr<>s, whose lifetime must end BEFORE CoUnitialize is called
	{
		// connect to WMI
		CComPtr< IWbemLocator > locator;
		hr = CoCreateInstance( CLSID_WbemAdministrativeLocator, NULL,
							CLSCTX_INPROC_SERVER,
							IID_IWbemLocator, reinterpret_cast< void** >( &locator ) );
		if ( FAILED( hr ) )
		{
			std::cerr << "Instantiation of IWbemLocator failed" << std::endl;
			return -1;
		}

		// connect to local service with current credentials
		CComPtr< IWbemServices > service;
		hr = locator->ConnectServer( L"root\\cimv2", NULL, NULL, NULL,
									 WBEM_FLAG_CONNECT_USE_MAX_WAIT,
									 NULL, NULL, &service );
		if ( SUCCEEDED( hr ) )
		{
			// determine platform via WMI
			CComPtr< IEnumWbemClassObject > pResults;
			hr = service->ExecQuery( L"WQL", L"SELECT Version FROM Win32_OperatingSystem",
										  0, NULL, &pResults );
			if ( SUCCEEDED( hr ) ) // query has been launched, wait for result
								   // of course, the polling done here is rather crude; there might be more 
								   // usefull stuff to do
			{
				CComPtr< IWbemClassObject > pVersion;
				ULONG retcount;
				hr = pResults->Next( WBEM_INFINITE, 1L, &pVersion, &retcount );
				_variant_t result;
				hr = pVersion->Get( L"Version", 0, &result, NULL, NULL );
				if ( SUCCEEDED( hr ) )
				{
					enum { eOnLegacy, eOnXP, eOn2003Server } platform = eOnLegacy;

					_bstr_t str = result;
					if ( str >= _bstr_t( L"5.1" ) ) // 5.1 => Windows XP; this is a somewhat crude way
					{
						if ( str >= _bstr_t( L"5.2" ) ) platform = eOn2003Server;
						else platform = eOnXP;
					}

					if ( platform == eOnLegacy ) std::cout << "You must have Windows XP or Windows 2003 Server to run this demo" << std::endl;
					else
					{
						CComPtr< IUnsecuredApartment > pApartment;
						hr = CoCreateInstance( CLSID_UnsecuredApartment, NULL, CLSCTX_LOCAL_SERVER,
											   IID_IUnsecuredApartment,
											   reinterpret_cast< void** >( &pApartment ) );
						if ( SUCCEEDED(hr ) )
						{
							CComPtr< CPingSink > pSink;
							CComPtr< IWbemObjectSink > pStub; 
							if ( platform == eOnXP )
							{
								pSink = new CPingSinkUnsecure;
								hr = pApartment->CreateObjectStub( pSink, 
														reinterpret_cast< IUnknown** >( &pStub ) );
								if ( FAILED( hr ) ) std::cerr << "Couldn\'t create stub" << std::endl;
							}
							else // we're running on 2003 Server
							{
								CComPtr< IWbemUnsecuredApartment > aprt;
								hr = pApartment->QueryInterface( IID_IWbemUnsecuredApartment,
																 reinterpret_cast< void** >( &aprt ) );
								if ( SUCCEEDED( hr ) )
								{
									pSink = new CPingSink;
									hr = aprt->CreateSinkStub( pSink, WBEM_FLAG_UNSECAPP_CHECK_ACCESS,
																	NULL, &pStub );
									if ( FAILED( hr ) ) std::cerr << "Cannot create sink stub" << std::endl;
								}
								else std::cerr << "Cannot query interface IWbemUnsecuredApartement" << std::endl;
							}
							if ( SUCCEEDED( hr ) ) // apartment and stub have been created
							{
								// you might want to use a more real life ip address here
								hr = service->ExecQueryAsync( L"WQL", L"SELECT StatusCode FROM Win32_PingStatus WHERE Address=\'127.0.0.1\'",
															0, NULL, pStub );
								if ( FAILED( hr ) ) std::cerr << "Query failed" << std::endl;
								else
								{
									while ( pSink->m_inProgress ) Sleep( 500 ); // feign something useful to do
									std::cout << "Host is " << ( pSink->m_isReachable ? "" : "not " ) << "reachable" << std::endl;
								}
							}
						}
						else std::cerr << "Couldn\'t create apartment" << std::endl;
					}

				}
			}
			else
			{
				std::cerr << "Query failed" << std::endl;
				result = -1;
			}
		}
		else
		{
			std::cerr << "Couldn't connect to service" << std::endl;
			result = -1;
		}
	}
	CoUninitialize();

	return result;
}
